local LSM3 = LibStub("LibSharedMedia-3.0", true)
local LSM2 = LibStub("LibSharedMedia-2.0", true)
local SML = LibStub("SharedMedia-1.0", true)

Media = {}
Media.revision = tonumber(string.sub("$Revision$", 12, -3)) or 1

Media.registry = { ["font"] = {} }

function Media:Register(mediatype, key, data, langmask)
	if LSM3 then
		LSM3:Register(mediatype, key, data, langmask)
	end
	if LSM2 then
		LSM2:Register(mediatype, key, data)
	end
	if SML then
		SML:Register(mediatype, key, data)
	end
	if not Media.registry[mediatype] then
		Media.registry[mediatype] = {}
	end
	table.insert(Media.registry[mediatype], { key, data, langmask})
end

function Media.OnEvent(this, event, ...)
	if not LSM3 then
		LSM3 = LibStub("LibSharedMedia-3.0", true)
		if LSM3 then
			for m,t in pairs(Media.registry) do
				for _,v in ipairs(t) do
					LSM3:Register(m, v[1], v[2], v[3])
				end
			end
		end
	end
	if not LSM2 then
		LSM2 = LibStub("LibSharedMedia-2.0", true)
		if LSM2 then
			for m,t in pairs(Media.registry) do
				for _,v in ipairs(t) do
					LSM2:Register(m, v[1], v[2])
				end
			end
		end
	end
	if not SML then
		SML = LibStub("SharedMedia-1.0", true)
		if SML then
			for m,t in pairs(Media.registry) do
				for _,v in ipairs(t) do
					SML:Register(m, v[1], v[2])
				end
			end
		end
	end
end

Media.frame = CreateFrame("Frame")
Media.frame:SetScript("OnEvent", Media.OnEvent)
Media.frame:RegisterEvent("ADDON_LOADED")

		if not Media then return end
		local revision = tonumber(string.sub("$Revision: 63551 $", 12, -3))
		Media.revision = (revision > Media.revision) and revision or Media.revision
	 
-- borders --

Media:Register("border", "bdbord1", [[Interface\AddOns\bdmedia\bdbord1.tga]])


-- FONTS --





-- bar textures (statusbar) --

Media:Register("statusbar", "bdtex2", [[Interface\AddOns\bdmedia\bdtex2.tga]])
Media:Register("statusbar", "bdtex3", [[Interface\AddOns\bdmedia\bdtex3.tga]])
