---- vlakCooldowns
-- Written by Vlakarados @ Soulflayer EU (ru) /  @  
-- Hugely Based on KordaCooldown by Korda @ Tarren Mill EU / henrik_s @ wowinterface.com
-- Thanks to the wowinterface community that helped report bugs and suggestions and Kavrishka ;)

local vtexture = "Interface\\AddOns\\vlakCooldowns\\bartexture"
local vfont = "Interface\\AddOns\\vlakCooldowns\\font.ttf"

-- Growth
local valign = 1 -- 1 Horizontal, 0 Vertical

-- Position of BOTTOMLEFT of the icons from the bottom of the screen
local ypos = 320
local xpos = -250
local size = 50

-- Gap between icons
local gap = 3

-- If you wish to add more spells to the list, simply add a line with a spell ID number and a comma. 
-- Text that goes after "--" is a comment and is there simply to remember what is what.
-- Spell ID number can be found at wowhead as last numbers in the address bar, 
-- e.g. http://www.wowhead.com/spell=47241 is a link to Metamorphosis spell and the spell ID is 47241

-- Some spells are commented out (disabled) with "--" to the left of spell ID number, remove/add -- before spell ID to enable/disable them.
-- Warriors and paladins sure have a hella-lot of cooldown abilities.

local spells = {
	["PRIEST"] = {},
	["SHAMAN"] = {
		59159, -- Thunderstorm
		16166, -- Elemental Mastery // Bugged, shows this cooldown along with nature's swiftness as they share cooldowns
		60043, -- Lavaburst
		49271, -- Chain Lightning
		49233, -- Flame Shock
		
		16190, -- Mana Tide Totem
		-- 16188, -- Nature's Swiftness // Bugged
		55198, -- Tidal Force
		61301, -- Riptide
		
		556, -- Astral Recall
		51533, -- Feral Spirit
		30823, -- Shamanistic Rage
	},
	["ROGUE"] = {
		26889, -- Vanish
		26669, -- Evasion
		31224, -- Cloak of Shadows
		
		13877, -- Blade Flurry
		51690, -- Killing Spree
		13750, -- Adrenaline Rush
	},
	["DRUID"] = {
		49376, -- Feral Charge - Cat
		16979, -- Feral Charge - Bear
		48477, -- Rebirth
		33357, -- Dash
		5209,   -- Challenging Roar
		22842, -- Frenzied Regeneration
		48447, -- Tranquility
		50213, -- Tiger's Fury
		53312, -- Nature's Grasp
		
		53201, -- Starfall
		33831, -- Force of Nature
		61384, -- Typhoon
		
		50334, -- Berserk
		61336, -- Survival Instincts
		
		17116, -- Nature's Swiftness
	},
	["MAGE"] = {},
	["WARLOCK"] = {
		17928, -- Howl of Terror
		47860, -- Death Coil
		48020, -- Demonic Circle: Teleport
		61290, -- Shadowflame

		47241, -- Metamorphosis
		18708, -- Fel Domination
	},
	["PALADIN"] = {
		498,     -- Divine Protection
		642,     -- Divine Shield
		2812,   -- Holy Wrath
		6940,   -- Hand of Sacrifice
		10278, -- Hand of Protection
		1044,   -- Hand of Freedom
		1038,   -- Hand of Salvation
		48788, -- Lay on Hands
		19752, -- Divine Intervention
		31884, -- Avenging Wrath
		54428, -- Divine Plea
		
		53385, -- Divine Storm
		20066, -- Repentance
		
		31821, -- Aura Mastery
		20216, -- Divine Favor
		31842, -- Divine Illumination
	},
	["DEATHKNIGHT"] = {},
	["HUNTER"] = {},
	["WARRIOR"] = {
		676,     -- Disarm
		694,     -- Mocking Blow
		871,     -- Shield Wall
		5246,   -- Intimidating Shout
		1161,   -- Challenging Shout
		1719,   -- Recklessness
		2565,   -- Shield Block
		20230, -- Retaliation
		64382, -- Shattering Throw
		55694, -- Enraged Regeneration
		57755, -- Heroic Throw
		11578, -- Charge
	
		46924, -- Bladestorm
		12328, -- Sweeping Strikes
		
		12292, -- Death Wish
		60970, -- Heroic Fury
		
		12809, -- Concussion Blow
		12975, -- Last Stand
	
	},
}
-- Timer update throttle (in seconds)
local throttle = 0.3
----
local SetPoint = SetPoint
local GetTime = GetTime
local SetWidth = SetWidth
local SetValue, GetValue = SetValue, GetValue
local Show, Hide = Show, Hide
local pairs = pairs

local frames = { }
spells = spells[select(2, UnitClass("player"))]

local anchor = CreateFrame("Frame", "vlakCooldownsAnchor", UIParent)
anchor:SetHeight(size)
anchor:SetPoint("BOTTOMLEFT", UIParent, "BOTTOM", xpos, ypos)

local function position()
	local shown = 0
	for k,v in pairs(frames) do
		local frame = frames[k]
		local start, duration = GetSpellCooldown(frame.spell)
		if duration and duration > 1.5 then
			frame.start = start
			frame.duration = duration
			frame.bar:SetValue((frame.start - (GetTime() - frame.duration))/frame.duration)
			frame.tdur:SetText(math.floor(frame.start - (GetTime() - frame.duration)))
			
			-- fix for setting textures again when respecced. lol.
			frame.ttexture:SetTexture(GetSpellTexture(GetSpellInfo(frame.spell)))
			
			shown = shown + 1
			
			if valign == 1 then
				frame:SetPoint("LEFT", anchor, "LEFT", shown * (size-4+gap), 0)
			else
				frame:SetPoint("LEFT", anchor, "LEFT", 0, shown * (size+gap))
			end
			frame:Show()
		end
	end
	
	anchor:SetWidth(shown*(size+5) + shown - 1)	
end

-- Update function
local function timer(self, elapsed)
	self.lastupdate = self.lastupdate + elapsed
	if self.lastupdate > throttle then
		self.bar:SetValue((self.start - (GetTime() - self.duration))/self.duration)
		
		self.tdur:SetText(math.floor((self.start - (GetTime() - self.duration))))
		if self.bar:GetValue() < 0.05 then
			self:Hide()
			position()
		end
		
		local _, ddur = GetSpellCooldown(self.spell)
		if ddur == 0 then
			self:Hide()
			position()
		end

		self.lastupdate = 0
	end
end

local function create(spell)

	-- Backgrond
	local frame = CreateFrame("Frame", nil, UIParent)
	frame:SetHeight(size)
	frame:SetWidth(size-4)
	frame.texture = frame:CreateTexture("texture", "BACKGROUND")
	frame.texture:SetAllPoints(frame)
	frame.texture:SetTexture(0,0,0, 0.85)
	
	-- Cooldown Texture
	local texture = frame:CreateTexture()
	texture:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 2, 2)
	texture:SetTexture(GetSpellTexture(GetSpellInfo(spell)))
	texture:SetTexCoord(0.08,0.92,0.08,0.92)
	texture:SetHeight(size-8)
	texture:SetWidth(size-8)
	
	-- Text Timer
	local tdur = frame:CreateFontString(nil, "OVERLAY")
    tdur:SetFont(vfont, 12, "OUTLINE")
    tdur:SetShadowColor(0,0,0,1)
	tdur:SetText("")
	tdur:SetPoint("BOTTOMLEFT", frame, "BOTTOMLEFT", 2, 2)
	
	-- Status Bar Timer
	local bar = CreateFrame("StatusBar", nil, frame, "TextStatusBar")
	bar:SetStatusBarTexture(vtexture)
	bar:GetStatusBarTexture():SetVertexColor(200/255, 255/255, 0/255);
	bar:SetPoint("TOPLEFT", frame, "TOPLEFT", 2, -2)
	bar:SetHeight(3)
	bar:SetWidth(size-8)
	bar:SetMinMaxValues(0, 1)
	
	frame.bar = bar
	frame.tdur = tdur
	frame.ttexture = texture
	frame.lastupdate = 0
	frame:SetScript("OnUpdate", timer)
	
	frame.spell = spell
	
	frame:Hide()
	
	return frame
end

-- Event Handling
local function event(self, event)	
	if event == "SPELLS_CHANGED" or event == "PLAYER_ENTERING_WORLD" or event == "PLAYER_TALENT_UPDATE" then	
		for k, v in pairs(spells) do
			if GetSpellInfo(v) then
				frames[v] = frames[v] or create(spells[k])
			end
		end
	end
	
	if event == "SPELL_UPDATE_COOLDOWN" then
		position()
	end
end

local vlakCooldowns = CreateFrame("Frame")
vlakCooldowns:RegisterEvent("PLAYER_ENTERING_WORLD")
vlakCooldowns:RegisterEvent("SPELL_UPDATE_COOLDOWN")
vlakCooldowns:RegisterEvent("SPELLS_CHANGED")
vlakCooldowns:RegisterEvent("PLAYER_TALENT_UPDATE")

vlakCooldowns:SetScript("OnEvent", event)