local exclusions = {
	2154, -- The Story of Morgan Ladimore
	3300, -- Rabbit's Foot
	3899, -- Legends of the Gurubashi, Volume 3
	6196, -- Noboru's Cudgel
}

local function isExclusion(link)
	for i, v in ipairs(exclusions) do
		if tostring(v) == select(3, string.find(link, "item:(%d+):")) then return true end
	end
end

local f = CreateFrame("Frame")

f:RegisterEvent("MERCHANT_SHOW")
f:SetScript("OnEvent", function()
	for bag = 0, 4 do
		for slot = 1, GetContainerNumSlots(bag) do
			local link = GetContainerItemLink(bag, slot)
			if (link) and (select(3, GetItemInfo(link)) == 0) and not (isExclusion(link)) then
				UseContainerItem(bag, slot)
			end
		end
	end
end)
