BINDING_HEADER_TTHELPER = "TricksHelper"

TricksHelperLDB = LibStub("AceAddon-3.0"):NewAddon("TricksHelperLDB", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("TricksHelper",true)
local QTC = LibStub('LibQTip-1.0')
local icon =  LibStub("LibDBIcon-1.0")

local addon = TricksHelperLDB
local TTHText = "TTH"
local channels = {["RAID"] = "Raid", ["PARTY"] = "Party", ["WHISPER"] = "Whisper", ["SAY"] = "Say", ["EMOTE"] = "Emote"}

local function set(info, value)
		local key = info[#info] 
		addon.db.profile[key] = value		
end

local function get(info)
		local key = info[#info] 
		return addon.db.profile[key]
end

local defaults = {
	  profile = {
		LibDBIcon = { hide = false },
		cChannel = "PARTY",		
		Name = "",
	  Petname = L["unknown"],	  
	  bAnnounce = false,	  
	},	
}
   
local optionsTable = {
	handler = addon,
	type = 'group',
	desc = "TricksHelper",
	inline = true,
	args = {
		basicDesc = {
			order = 1,
			type = 'description',
			name = "TricksHelper Options",
		},	
		showMinimapIcon = {
			order = 2,
			type = 'toggle',
			name = "Minimap Icon",
			desc = "Toggle Minimap icon.",
			get = function(info) return not addon.db.profile.LibDBIcon.hide end,
			set = function(info, value)
				addon.db.profile.LibDBIcon.hide = not value
				if v then
					icon:Show("TricksHelper")
				else
					icon:Hide("TricksHelper")
				end
			end,
		},
		buffmessage = {
			order = 3,
			type = 'toggle',
			name = "Buff Alert",
			desc = "Toggle Tricks Applied Announcing",
			get = function(info) return addon.db.profile.bAnnounce end,
			set = function(info, value)
				addon.db.profile.bAnnounce = value
			end,
		},
		cChannel = {
		  type = 'select',
		  name = "Buff Channel",
		  desc = "Select Channel for Buff Announcements",
		  order = 4,
		  get = function(info) return addon.db.profile.cChannel end,
		  set = function(info, value)
				  addon.db.profile.cChannel = value
			   end,
		  values = channels,
	  },    
	},	
}

local function HideTooltip()
	if not tooltip then return end
	if tooltip and MouseIsOver(tooltip) then return end
	tooltip:SetScript("OnLeave", HideTooltip)
	tooltip:Hide()
	QTC:Release(tooltip)
	tooltip = nil
end

local function HandlerFunc( cell, arg, button)
   local btn
    if arg == "b1" then
      addon:PrtyTank()      
    elseif arg == "b2" then
      addon:PlyrTarg()
    elseif arg == "b3" then
      addon:ToT()
    elseif arg == "b4" then
      addon:PopUp() 
    elseif arg == "b5" then
      InterfaceOptionsFrame_OpenToCategory(addon.optionsFrame)
    end 
end

local function DrawTooltip()    
    tooltip:Hide() 
    tooltip:Clear()    
    local headerFont = CreateFont("TricksHelperHeaderFont")
	  TricksHelperHeaderFont:CopyFontObject(GameTooltipHeaderText)
	  TricksHelperHeaderFont:SetFont(TricksHelperHeaderFont:GetFont(), 15)
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "|cffffff00TricksHelper|r",TricksHelperHeaderFont, "CENTER", 1)
    tooltip:SetLineColor(1, 1, 0, 1, 1)    
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(2, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
    tooltip:SetLineColor(3, 0, 0, 1, 1)
    local y = tooltip:AddLine()
    y = tooltip:SetCell(y, 1, "Set To Party Tank", "CENTER", 1)
    tooltip:SetCellScript( y, 1, "OnMouseDown", 
			HandlerFunc, "b1" )
    tooltip:SetLineColor(4, 1, 0, 0, 1)    
    local y = tooltip:AddLine()
    y = tooltip:SetCell(y, 1, "Set To Target", "CENTER", 1)
    tooltip:SetCellScript( y, 1, "OnMouseDown", 
			HandlerFunc, "b2" )
    tooltip:SetLineColor(5, 1, 0, 0, 1)
    local y = tooltip:AddLine()
    y = tooltip:SetCell(y, 1, "Set to TargetOfTarget", "CENTER", 1)
    tooltip:SetCellScript( y, 1, "OnMouseDown", 
			HandlerFunc, "b3" )
    tooltip:SetLineColor(6, 1, 0, 0, 1)
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(7, 0, 0, 1, 1)
    local y = tooltip:AddLine()
    y = tooltip:SetCell(y, 1, "Enter Player Name", "CENTER", 1)
	  tooltip:SetCellScript( y, 1, "OnMouseDown", 
			HandlerFunc, "b4" )
	  tooltip:SetLineColor(8, 0, 1, 1, 1)    
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(9, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(10, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
    y = tooltip:SetCell(y, 1, "TricksHelper Options", "CENTER", 1)
    tooltip:SetCellScript( y, 1, "OnMouseDown", 
			HandlerFunc, "b5" )
    tooltip:SetLineColor(11, 0, 1, 0, 1)
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(12, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(13, 0, 0, 1, 1)    
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "|cffffff00Tricks is set to:|r|cffff0033 " .. addon:TTText(), "CENTER", 1)
	  tooltip:SetLineColor(14, 1, 0, 1, 0)
    local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(15, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "", "CENTER", 1)
	  tooltip:SetLineColor(16, 0, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "|cffffff00 Left Click Each Text To Activate|r ", "CENTER", 1)
	  tooltip:SetLineColor(17, 1, 0, 1, 1)
	  local y = tooltip:AddLine()
	  tooltip:SetCell(y, 1, "|cffffff00Right Click For TTH Options|r", "CENTER", 1)
    tooltip:SetLineColor(18, 1, 0, 1, 1)
    if (InCombatLockdown()) then return end    
    tooltip:Show()
end

--Create the data broker
TricksHelperLDB.dataObject = LibStub:GetLibrary("LibDataBroker-1.1"):NewDataObject("TricksHelper", {
	  type = "data source",
	  text = TTHText,
    icon = "Interface\\Icons\\Ability_Rogue_TricksOftheTrade",
    OnClick = function(frame, button)
				if button == "RightButton" then
				   InterfaceOptionsFrame_OpenToCategory(addon.optionsFrame)
			  elseif button == "LeftButton" then
	         addon:PlyrTarg()
				end
			end,
		OnEnter = function(frame)
				tooltip = QTC:Acquire("Broker_TricksHelperTooltip", 1, "CENTER")
				tooltip:SmartAnchorTo(frame)
				tooltip:SetAutoHideDelay(1.25, frame)		
				DrawTooltip()		    				
			end,
		OnLeave = function()
				HideTooltip()
			end,
})

function addon:TTHTextUpdate()
	 if addon.db.profile.Name == "" then
	   TricksHelperLDB.dataObject.text = (TTHText)
	 else
	   TricksHelperLDB.dataObject.text = (addon.db.profile.Name)
	 end
end

function addon:PlyrTarg()
   addon:TTHtarget();
	 addon:TTHEditMacro();
end

function addon:TTHtank()
	local NumParty=GetNumPartyMembers();
	local NumRaid=GetNumRaidMembers();
	local TTHhealth = 0;
	local TTHtank = addon.db.profile.Name
	if (0 < NumParty and NumRaid == 0) then
		for i=1, NumParty, 1 do
			_, class=UnitClass("party"..i);
			if ("WARRIOR" == class or "DRUID" == class or "DEATHKNIGHT" == class or "PALADIN" == class) then
				if (TTHhealth < UnitHealth("party"..i)) then
					TTHhealth = UnitHealth("party"..i);
					TTHtank = UnitName("party"..i);
				end
			end				
		end
	elseif (0 < NumRaid) then
		for i=1, NumRaid, 1 do
			_, class=UnitClass("raid"..i);
			if ("WARRIOR" == class or "DRUID" == class or "DEATHKNIGHT" == class or "PALADIN" == class) then
				if (TTHhealth < UnitHealth("raid"..i)) then
					TTHhealth = UnitHealth("raid"..i);
					TTHtank = UnitName("raid"..i);
				end
			end				
		end
	end
	addon.db.profile.Name = TTHtank;
end

function addon:PrtyTank()
	 addon:TTHtank();
	 addon:TTHEditMacro();
end

function addon:ToT()
	addon.db.profile.Name = "targettarget"; 
	addon:TTHEditMacro();
end

function addon:PopUp()
    StaticPopupDialogs["TTH_GET_PLAYER_NAME"] = {
			text = "Player to Trick to:", button1 = "OK", button2 = "Cancel", hasEditBox = 1,
			OnAccept = function()
				 if not (UnitAffectingCombat("player")) then
				   addon.db.profile.Name = getglobal(this:GetParent():GetName().."EditBox"):GetText().." "				 			       
		        if (addon.db.profile.Name == "Target" or addon.db.profile.Name == "target" or addon.db.profile.Name == "t")then
			         addon:MHDtarget();
		        end
		      addon:TTHEditMacro();
	       end
			end,
			timeout = 0, whileDead = 1, hideOnEscape = 1
		}
		StaticPopup_Show("TTH_GET_PLAYER_NAME");
		return
end

function addon:TTHLoad()
	 addon:TTHTextUpdate()
end

function addon:TTHtarget()
	if(UnitExists("target")) then
		addon.db.profile.Name = UnitName("target")
	end
end

function addon:TTHEditMacro()
	addon:TTHTextUpdate()	
	if (addon.db.profile.Name == "targettarget") then
		 macro = string.format("#showtooltip %s\n/target targettarget\n/cast %s\n/targetlasttarget\n","Tricks of the Trade","Tricks of the Trade");
	else
		 macro = string.format("#showtooltip %s\n/target %s\n/cast %s\n/targetlasttarget","Tricks of the Trade", addon.db.profile.Name,"Tricks of the Trade");
	end
	local macroid = GetMacroIndexByName("Tricks");
	if (macroid == 0) then
		CreateMacro("Tricks", 375, macro, 1, 1);
	else
		EditMacro(macroid, "Tricks", 375, macro);
	end
end

function addon:TTHChat()
	if IsAddOnLoaded("CastYeller2") or IsAddOnLoaded("CastYeller") then return end
	if (addon.db.profile.cChannel == "PARTY" and GetNumPartyMembers() ~= 0) then
		SendChatMessage(L["displaytext1"]..misdtarget..L["displaytext2"].."!", addon.db.profile.cChannel, GetDefaultLanguage("player"));
	elseif (addon.db.profile.cChannel == "RAID" and GetNumRaidMembers() ~= 0) then
		SendChatMessage(L["displaytext1"]..misdtarget..L["displaytext2"].."!", addon.db.profile.cChannel, GetDefaultLanguage("player"));
	elseif (addon.db.profile.cChannel == "WHISPER") then
		SendChatMessage(L["displaytext1"]..misdtarget..L["displaytext2"].."!", addon.db.profile.cChannel, GetDefaultLanguage("player"), misdtarget);	
	elseif (addon.db.profile.cChannel == "SAY") then
		SendChatMessage(L["displaytext1"]..misdtarget..L["displaytext2"].."!", addon.db.profile.cChannel, GetDefaultLanguage("player"));
	elseif (addon.db.profile.cChannel == "EMOTE") then
		SendChatMessage(L["displaytext1"]..misdtarget..L["displaytext2"].."!", addon.db.profile.cChannel, GetDefaultLanguage("player"));	
	end
end

function addon:OnInitialize()	
	 if select(2,UnitClass("player")) == ("ROGUE") then
	   addon.db = LibStub("AceDB-3.0"):New("TricksHelperDB", defaults)
	   optionsTable.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(addon.db)
	   LibStub("AceConfig-3.0"):RegisterOptionsTable("TricksHelper", optionsTable)
	   addon.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("TricksHelper", "TricksHelper")	
	   if icon then
		   icon:Register("TricksHelper", TricksHelperLDB.dataObject, addon.db.profile.LibDBIcon)		
	   end	
     addon:TTHOnload()
   else
     return
   end
end

function addon:TTHOnload()
   addon:RegisterEvent('PLAYER_ENTERING_WORLD')
	 addon:RegisterEvent('UNIT_SPELLCAST_SENT')
	 addon:RegisterEvent('UNIT_SPELLCAST_SUCCEEDED')
end

function addon:PLAYER_ENTERING_WORLD()
  addon:TTHLoad()
end

function addon:UNIT_SPELLCAST_SENT()
  if (arg1 == "player" and arg2 == GetSpellInfo(57934)) then
	  misdtarget = arg4;
  end
end

function addon:UNIT_SPELLCAST_SUCCEEDED()
    if (arg1 == "player" and arg2 == GetSpellInfo(57934)) then			
			if (addon.db.profile.bAnnounce) then
				addon:TTHChat();
			end
		end
end

function addon:TTText()
  if addon.db.profile.Name == "" then
    return "No One"
  else
    return addon.db.profile.Name
  end
end