local theme = TidyPlatesThemeList["Neon/Tank"]
TidyPlatesNeonTankSavedVariables = {}
---------------
-- Helpers
---------------
local copytable = TidyPlatesUtility.copyTable
local updatetable = TidyPlatesUtility.updateTable
local PanelHelpers = TidyPlatesUtility.PanelHelpers

------------------------------------------------------------------
-- Interface Options Panel
------------------------------------------------------------------
local TextModes = { { text = "None", notCheckable = 1 },
					{ text = "Percent", notCheckable = 1 } ,
					{ text = "Actual", notCheckable = 1 } ,
					{ text = "Defecit", notCheckable = 1 } ,
					{ text = "Total & Percent", notCheckable = 1 } ,
					{ text = "Plus-and-Minus", notCheckable = 1 } ,
					{ text = "Level", notCheckable = 1 } ,
					}
-------------------
-- Main Panel
-------------------
local panel = PanelHelpers:CreatePanelFrame( "TidyPlatesNeonTank_InterfaceOptionsPanel", "Neon/Tank Theme" )
panel.parent = "Tidy Plates"
panel:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", insets = { left = 2, right = 2, top = 2, bottom = 2 },})
panel:SetBackdropColor(0.05, 0.05, 0.05, .7)

local column1, column2 = -90, -100
-------------------
-- Opacity
-------------------
-- Non-Targets Opacity Slider
panel.OpacityNonTarget = PanelHelpers:CreateSliderFrame("TidyPlatesNeonTank_OpacityNonTargets", panel, "Non-Target Opacity:", .5, 0, 1, .1)
panel.OpacityNonTarget:SetPoint("CENTER", -37+column1, 133)
-- Hide Neutral Units Checkbox
panel.OpacityHideNeutral = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_OpacityHideNeutral", panel, "Hide Neutral Units")
panel.OpacityHideNeutral:SetPoint("CENTER", -81+column1, 95)
-- Hide Non-Elites Checkbox
panel.OpacityHideNonElites = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_OpacityHideNonElites", panel, "Hide Non-Elites")
panel.OpacityHideNonElites:SetPoint("CENTER", -81+column1, 71)
-------------------
-- Scale
-------------------
-- General Scale
local adjustGeneral = 25
panel.ScaleGeneral = PanelHelpers:CreateSliderFrame("TidyPlatesNeonTank_ScaleGeneral", panel, "General Scale:", 1, .5, 2, .1)
panel.ScaleGeneral:SetPoint("CENTER", -35+column1, 34-adjustGeneral)
-- Loose Units Scale
panel.ScaleLoose = PanelHelpers:CreateSliderFrame("TidyPlatesNeonTank_ScaleLoose", panel, "Lost Unit Scale:", 1.5, 1, 2, .1)
panel.ScaleLoose:SetPoint("CENTER", -35+column1, -24-adjustGeneral)
-- Hide Non-Elites Checkbox
panel.ScaleIgnoreNonElite = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_ScaleIgnoreNonElite", panel, "Ignore Non-Elites")
panel.ScaleIgnoreNonElite:SetPoint("CENTER", -81+column1, -62-adjustGeneral)

-------------------
-- Aggro
-------------------
local aggx, aggy = 18, 220+54  -- /script print(GetCursorPosition())
panel.AggroDesc = PanelHelpers:CreateDescriptionFrame("TidyPlatesNeonTank_AggroDesc", panel, "Aggro Status Colors:", "")
panel.AggroDesc:SetPoint("CENTER", -35+column1+aggx, 92-aggy)
-- Loose Units
panel.AggroLooseColor = PanelHelpers:CreateColorBox("TidyPlatesNeonTank_AggroLooseColor", panel, "Loose Color", 0, .5, 1, 1)
panel.AggroLooseColor:SetPoint("CENTER", -35+column1-32, 71+55-aggy)
-- Tanked Units
panel.AggroTankedColor = PanelHelpers:CreateColorBox("TidyPlatesNeonTank_AggroTanked", panel, "Aggro Color", 0, .5, 1, 1)
panel.AggroTankedColor:SetPoint("CENTER", -35+column1-32, 44+55-aggy)


-------------------
-- Threat Widget
-------------------
local widgetx, widgety = 175, 255
-- Widget Offsets = 24px
-- Description
panel.WidgetDesc = PanelHelpers:CreateDescriptionFrame("TidyPlatesNeonTank_WidgetDesc", panel, "Widgets:", "")
panel.WidgetDesc:SetPoint("CENTER", -11+column1+widgetx, -136+widgety-25)
-- Selection Box
panel.WidgetSelect = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetSelect", panel, "Selection Box")
panel.WidgetSelect:SetPoint("CENTER", -74+column1+widgetx, -100-(24)+widgety)
-- Tug-o'-Threat
panel.WidgetTug = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetTug", panel, "Tug-o'-Threat")
panel.WidgetTug:SetPoint("CENTER", -74+column1+widgetx, -100-(24*2)+widgety)

-- Loose 
panel.TugWidgetLooseColor = PanelHelpers:CreateColorBox("TidyPlatesNeonTank_TugWidgetLooseColor", panel, "Loose Color", 0, .5, 1, 1)
panel.TugWidgetLooseColor:SetPoint("CENTER", 137+column2-10, -100-(24*3)+widgety)
-- Aggro'd 
panel.TugWidgetAggroColor = PanelHelpers:CreateColorBox("TidyPlatesNeonTank_TugWidgetAggroColor", panel, "Aggro Color", 0, .5, 1, 1)
panel.TugWidgetAggroColor:SetPoint("CENTER", 137+column2-10, -100-(24*4)+widgety)
-- Safe 
panel.TugWidgetSafeColor = PanelHelpers:CreateColorBox("TidyPlatesNeonTank_TugWidgetSafeColor", panel, "Safe/Off-tank Color", 0, .5, 1, 1)
panel.TugWidgetSafeColor:SetPoint("CENTER", 137+column2-10, -100-(24*5)+widgety)
-- Short Debuffs
panel.WidgetDebuff = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetDebuff", panel, "Dots & Debuffs")
panel.WidgetDebuff:SetPoint("CENTER", -74+column1+widgetx, -100-(24*6)+widgety-5)

-- Mob Notes
--[[
panel.WidgetMobNote = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetMobNote", panel, "Mob Notes")
panel.WidgetMobNote:SetPoint("CENTER", -74+column1+widgetx, -100-(24*7)+widgety-5)
--]]

-- Combos
panel.WidgetCombo = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetCombo", panel, "Combo Points")
panel.WidgetCombo:SetPoint("CENTER", -74+column1+widgetx, -100-(24*7)+widgety-5)

-- Group Range
panel.WidgetRange = PanelHelpers:CreateCheckButton("TidyPlatesNeonTank_WidgetRange", panel, "Range Watcher")
panel.WidgetRange:SetPoint("CENTER", -74+column1+widgetx, -100-(24*8)+widgety-5)

-- [[

local RangeModes = { { text = "9 yards", notCheckable = 1 } , 
					{ text = "15 yards", notCheckable = 1 } ,
					{ text = "28 yards", notCheckable = 1 } ,
					{ text = "40 yards", notCheckable = 1 } ,
					}
					
-------------------
-- Range
-------------------
panel.RangeMode = PanelHelpers:CreateDropdownFrame("TidyPlatesNeonTank_RangeModeDropdown", panel, RangeModes, 1, "")
panel.RangeMode:SetPoint("CENTER", -74+column1+widgetx+8, -100-(24*9)+widgety-5-5)
--]]

-------------------
-- Health Text
-------------------
panel.HealthText = PanelHelpers:CreateDropdownFrame("TidyPlatesNeonTank_HealthText", panel, TextModes, 1, "Health Text Mode:")
panel.HealthText:SetPoint("CENTER", -74+column1+widgetx, -145)

-------------------
-- Apply Button
-------------------
panel.apply = CreateFrame("Button", "TidyPlatesNeonTank_ApplyButton", panel, "UIPanelButtonTemplate2")
panel.apply:SetPoint("BOTTOMRIGHT", panel, -15, 15)
panel.apply:SetText("Apply")
panel.apply:SetWidth(80)

local function GetPanelValues()
	local index, value
	for index, value in pairs(TidyPlatesNeonTankVariables) do
		TidyPlatesNeonTankVariables[index] = panel[index]:GetValue()
		TidyPlatesNeonTankSavedVariables[index] = TidyPlatesNeonTankVariables[index]
	end
end

local function SetPanelValues()
	local index, value
	for index, value in pairs(TidyPlatesNeonTankVariables) do
		panel[index]:SetValue(TidyPlatesNeonTankVariables[index])
	end
end

local function GetSavedVariables()
	local index, value
	TidyPlatesNeonTankVariables = updatetable(TidyPlatesNeonTankVariables, TidyPlatesNeonTankSavedVariables)
end

-- Update Variables
panel.okay = function ()
	GetPanelValues()
	--TidyPlates:ReloadTheme()
	TidyPlates:ForceUpdate()
	
end

panel.apply:SetScript("OnClick",panel.okay)
panel.refresh = SetPanelValues

-- Login
panel:SetScript("OnEvent", function(self, event, ...) 
	if event == "PLAYER_LOGIN" then 
		InterfaceOptions_AddCategory(panel)
	elseif event == "PLAYER_ENTERING_WORLD" then -- "PLAYER_ENTERING_WORLD"
		GetSavedVariables()
	end
	
end)
panel:RegisterEvent("PLAYER_LOGIN")
panel:RegisterEvent("PLAYER_ENTERING_WORLD")

-- Slash Command
function slash_NEONTANK(arg) InterfaceOptionsFrame_OpenToCategory(panel); end
SLASH_NEONTANK1 = '/neontank'
SlashCmdList['NEONTANK'] = slash_NEONTANK;


